/*
 * Decompiled with CFR 0.152.
 */
package com.brokenevent.nanotests.http;

import com.brokenevent.nanotests.http.TestRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;

class TestRequestImpl
implements TestRequest {
    protected HttpClient client = HttpClients.createDefault();
    protected HttpRequest request;
    protected HttpResponse response;
    private String resource;
    protected static String hostUrl = "http://localhost";
    protected static HttpHost host = HttpHost.create((String)hostUrl);

    public static void setHostUrl(String hostUrl) {
        TestRequestImpl.hostUrl = hostUrl;
    }

    TestRequestImpl(String resource) {
        this.resource = resource;
    }

    public void setHeader(String name, String value) {
        this.request.setHeader(name, value);
    }

    public void removeHeader(String name) {
        this.request.removeHeaders(name);
    }

    public void setUserAgent(String value) {
        this.request.setHeader("User-Agent", value);
    }

    public void execute() {
        try {
            this.response = this.client.execute(host, this.request);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to do GET to " + hostUrl, e);
        }
    }

    public String getRequestUrl() {
        return String.valueOf(hostUrl) + this.resource;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getStringContent() {
        if (this.response == null) {
            return null;
        }
        try {
            int read;
            InputStream stream = this.response.getEntity().getContent();
            ByteArrayOutputStream cache = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                cache.write(buffer, 0, read);
            }
            return new String(cache.toByteArray());
        }
        catch (IOException e) {
            throw new AssertionError("Failed to get content", e);
        }
    }
}

