/*
 * Decompiled with CFR 0.152.
 */
package com.brokenevent.nanotests;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XmlAssert {
    protected XmlAssert() {
    }

    public static Document loadDocument(String content) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(content)));
        }
        catch (Exception ex) {
            throw new AssertionError("XML parsing error", ex);
        }
    }

    public static void assertElementContent(Document doc, String path, String expected) {
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expression = xpath.compile(path);
            Assert.assertEquals((Object)expected, (Object)expression.evaluate(doc, XPathConstants.STRING));
        }
        catch (XPathExpressionException ex) {
            throw new AssertionError("XPath parsing error", ex);
        }
    }

    public static void assertElementName(Document doc, String path, String expected) {
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expression = xpath.compile(path);
            Assert.assertEquals((Object)expected, (Object)((Node)expression.evaluate(doc, XPathConstants.NODE)).getNodeName());
        }
        catch (XPathExpressionException ex) {
            throw new AssertionError("XPath parsing error", ex);
        }
    }

    public static void assertElementsCount(Document doc, String path, int expectedCount) {
        try {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expression = xpath.compile(path);
            Assert.assertEquals((long)expectedCount, (long)((NodeList)expression.evaluate(doc, XPathConstants.NODESET)).getLength());
        }
        catch (XPathExpressionException ex) {
            throw new AssertionError("XPath parsing error", ex);
        }
    }
}

