/*
 * Decompiled with CFR 0.152.
 */
package com.brokenevent.nanotests;

import com.brokenevent.nanotests.http.TestGetRequest;
import com.brokenevent.nanotests.http.TestRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.junit.Assert;

public final class HttpAssert {
    protected HttpAssert() {
    }

    private static String normalizeUrl(String value) {
        return value.replaceAll(" ", "%20");
    }

    public static void assertHttpOk(TestRequest request) {
        Assert.assertEquals((String)request.getRequestUrl(), (long)200L, (long)request.getResponse().getStatusLine().getStatusCode());
    }

    public static void assertHttpOk(String message, TestRequest request) {
        Assert.assertEquals((String)message, (long)200L, (long)request.getResponse().getStatusLine().getStatusCode());
    }

    public static void assertHttpCode(TestRequest request, int code) {
        Assert.assertEquals((String)request.getRequestUrl(), (long)code, (long)request.getResponse().getStatusLine().getStatusCode());
    }

    public static void assertHttpCode(String message, TestRequest request, int code) {
        Assert.assertEquals((String)message, (long)code, (long)request.getResponse().getStatusLine().getStatusCode());
    }

    public static void assertHttpHeader(TestRequest request, String name, String value) {
        Header header = request.getResponse().getLastHeader(name);
        Assert.assertNotNull((String)("Header field " + name), (Object)header);
        Assert.assertEquals((String)("Header field " + name), (Object)value, (Object)header.getValue());
    }

    public static void assertHttpHeader(String message, TestRequest request, String name, String value) {
        Header header = request.getResponse().getLastHeader(name);
        Assert.assertNotNull((String)message, (Object)header);
        Assert.assertEquals((String)message, (Object)value, (Object)header.getValue());
    }

    public static void assertHttpIsHeader(TestRequest request, String name) {
        if (request.getResponse().getLastHeader(name) == null) {
            Assert.fail();
        }
    }

    public static void assertHttpIsHeader(String message, TestRequest request, String name) {
        if (request.getResponse().getLastHeader(name) == null) {
            Assert.fail((String)message);
        }
    }

    public static void assertHttpNoHeader(TestRequest request, String name) {
        Assert.assertNull((String)("Header field " + name), (Object)request.getResponse().getLastHeader(name));
    }

    public static void assertHttpNoHeader(String message, TestRequest request, String name) {
        Assert.assertNull((String)message, (Object)request.getResponse().getLastHeader(name));
    }

    public static void assertHttpOk(String resource) {
        HttpAssert.assertHttpCode(resource, 200);
    }

    public static void assertHttp404(String resource) {
        HttpAssert.assertHttpCode(resource, 404);
    }

    public static void assertHttpCode(String resource, int code) {
        resource = HttpAssert.normalizeUrl(resource);
        TestGetRequest request = new TestGetRequest(resource);
        request.execute();
        if (request.getResponse().getStatusLine().getStatusCode() != code) {
            Assert.fail((String)("Response for " + resource + " is " + request.getResponse().getStatusLine().getStatusCode()));
        }
    }

    public static void assertHttpContent(TestRequest request, String expected) {
        try {
            int read;
            InputStream stream = request.getResponse().getEntity().getContent();
            ByteArrayOutputStream cache = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                cache.write(buffer, 0, read);
            }
            Assert.assertEquals((Object)expected, (Object)new String(cache.toByteArray()));
        }
        catch (IOException e) {
            throw new AssertionError("Failed to get content", e);
        }
    }

    public static void assertHttpContent(TestRequest request, byte[] expected) {
        try {
            int read;
            InputStream stream = request.getResponse().getEntity().getContent();
            ByteArrayOutputStream cache = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                cache.write(buffer, 0, read);
            }
            Assert.assertArrayEquals((byte[])expected, (byte[])cache.toByteArray());
        }
        catch (IOException e) {
            throw new AssertionError("Failed to get content", e);
        }
    }

    public static void assertHttpContent(TestRequest request, Pattern expected) {
        try {
            int read;
            InputStream stream = request.getResponse().getEntity().getContent();
            ByteArrayOutputStream cache = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                cache.write(buffer, 0, read);
            }
            String content = new String(cache.toByteArray());
            if (!expected.matcher(content).matches()) {
                throw new AssertionError((Object)("Regex check failed: " + expected));
            }
        }
        catch (IOException e) {
            throw new AssertionError("Failed to get content", e);
        }
    }

    public static void assertHttpContent(String resource, String expected) {
        TestGetRequest request = new TestGetRequest(resource);
        request.execute();
        HttpAssert.assertHttpOk(request);
        HttpAssert.assertHttpContent((TestRequest)request, expected);
    }

    public static void assertHttpContent(String resource, byte[] expected) {
        TestGetRequest request = new TestGetRequest(resource);
        request.execute();
        HttpAssert.assertHttpOk(request);
        HttpAssert.assertHttpContent((TestRequest)request, expected);
    }

    public static void assertHttpContent(String resource, Pattern expected) {
        TestGetRequest request = new TestGetRequest(resource);
        request.execute();
        HttpAssert.assertHttpOk(request);
        HttpAssert.assertHttpContent((TestRequest)request, expected);
    }
}

