/*
 * Decompiled with CFR 0.152.
 */
package com.brokenevent.nanotests;

import com.brokenevent.nanotests.db.ConnectionWrapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DbAssert {
    private static List<ConnectionWrapper> wrappers = new ArrayList<ConnectionWrapper>();
    private static final Object lock = new Object();
    private static String connectionString;
    private static String login;
    private static String password;

    protected DbAssert() {
    }

    public static void initDbAssert(String connectionString, String login, String password, String driverClassName) {
        try {
            Class.forName(driverClassName);
            DbAssert.connectionString = connectionString;
            DbAssert.login = login;
            DbAssert.password = password;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError("Failed to register db driver: " + driverClassName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionWrapper getConnection() throws SQLException {
        Object object = lock;
        synchronized (object) {
            ConnectionWrapper wrapper2;
            for (ConnectionWrapper wrapper2 : wrappers) {
                if (wrapper2.isBusy()) continue;
                return wrapper2;
            }
            wrapper2 = new ConnectionWrapper(connectionString, login, password);
            wrappers.add(wrapper2);
            return wrapper2;
        }
    }

    public static void shutdownDbAssert() {
        try {
            for (ConnectionWrapper wrapper : wrappers) {
                if (!wrapper.isBusy()) continue;
                return;
            }
            for (ConnectionWrapper wrapper : wrappers) {
                wrapper.release();
            }
            wrappers.clear();
        }
        catch (SQLException e) {
            throw new AssertionError("Failed to disconnect from db", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Map<String, Object>> query(String sql) {
        List<Map<String, Object>> list;
        ConnectionWrapper wrapper = null;
        try {
            wrapper = DbAssert.getConnection();
            Statement statement = wrapper.getStatement();
            list = DbAssert.processResultSet(statement.executeQuery(sql));
            if (wrapper == null) return list;
        }
        catch (SQLException sQLException) {
            try {
                throw new AssertionError((Object)("Fail on process result set for " + sql));
            }
            catch (Throwable throwable) {
                if (wrapper == null) throw throwable;
                try {
                    wrapper.close();
                    throw throwable;
                }
                catch (SQLException sQLException2) {
                    Assert.fail((String)"Failed to close SQL statement");
                }
                throw throwable;
            }
        }
        try {
            wrapper.close();
            return list;
        }
        catch (SQLException sQLException) {
            Assert.fail((String)"Failed to close SQL statement");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> querySingle(String sql) {
        Map<String, Object> map;
        ConnectionWrapper wrapper = null;
        try {
            wrapper = DbAssert.getConnection();
            Statement statement = wrapper.getStatement();
            map = DbAssert.processResultSetSingle(statement.executeQuery(sql));
            if (wrapper == null) return map;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new AssertionError((Object)("Fail on process result set for " + sql));
            }
            catch (Throwable throwable) {
                if (wrapper == null) throw throwable;
                try {
                    wrapper.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL statement");
                }
                throw throwable;
            }
        }
        try {
            wrapper.close();
            return map;
        }
        catch (SQLException sQLException) {
            Assert.fail((String)"Failed to close SQL statement");
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> querySingleColumn(String sql) {
        List<T> list;
        ConnectionWrapper wrapper = null;
        try {
            wrapper = DbAssert.getConnection();
            Statement statement = wrapper.getStatement();
            list = DbAssert.processResultSetSingleColumn(statement.executeQuery(sql));
            if (wrapper == null) return list;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new AssertionError((Object)("Fail on process result set for " + sql));
            }
            catch (Throwable throwable) {
                if (wrapper == null) throw throwable;
                try {
                    wrapper.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL statement");
                }
                throw throwable;
            }
        }
        try {
            wrapper.close();
            return list;
        }
        catch (SQLException sQLException) {
            Assert.fail((String)"Failed to close SQL statement");
        }
        return list;
    }

    public static void execute(String sql) {
        ConnectionWrapper wrapper = null;
        try {
            try {
                wrapper = DbAssert.getConnection();
                Statement statement = wrapper.getStatement();
                statement.execute(sql);
            }
            catch (SQLException e) {
                throw new AssertionError("Fail on execute: " + sql, e);
            }
        }
        catch (Throwable throwable) {
            if (wrapper != null) {
                try {
                    wrapper.close();
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL statement");
                }
            }
            throw throwable;
        }
        if (wrapper != null) {
            try {
                wrapper.close();
            }
            catch (SQLException sQLException) {
                Assert.fail((String)"Failed to close SQL statement");
            }
        }
    }

    private static List<Map<String, Object>> processResultSet(ResultSet resultSet) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ResultSetMetaData meta = resultSet.getMetaData();
        while (resultSet.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 0;
            while (i < meta.getColumnCount()) {
                map.put(meta.getColumnLabel(i + 1), resultSet.getObject(i + 1));
                ++i;
            }
            result.add(map);
        }
        return result;
    }

    private static Map<String, Object> processResultSetSingle(ResultSet resultSet) throws SQLException {
        ResultSetMetaData meta = resultSet.getMetaData();
        if (resultSet.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = 0;
            while (i < meta.getColumnCount()) {
                map.put(meta.getColumnLabel(i + 1), resultSet.getObject(i + 1));
                ++i;
            }
            return map;
        }
        return null;
    }

    private static <T> List<T> processResultSetSingleColumn(ResultSet resultSet) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        while (resultSet.next()) {
            result.add(resultSet.getObject(1));
        }
        return result;
    }

    public static void assertQueryNotNull(String sql) {
        ConnectionWrapper wrapper = null;
        try {
            try {
                wrapper = DbAssert.getConnection();
                Statement statement = wrapper.getStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) {
                    Assert.fail((String)("Query <" + sql + "> result is empty, but expected to be not empty"));
                }
            }
            catch (SQLException sQLException) {
                throw new AssertionError((Object)"Fail on resultSet.next()");
            }
        }
        catch (Throwable throwable) {
            if (wrapper != null) {
                try {
                    wrapper.close();
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL statement");
                }
            }
            throw throwable;
        }
        if (wrapper != null) {
            try {
                wrapper.close();
            }
            catch (SQLException sQLException) {
                Assert.fail((String)"Failed to close SQL statement");
            }
        }
    }

    public static void assertQueryNull(String sql) {
        ConnectionWrapper wrapper = null;
        ResultSet resultSet = null;
        try {
            try {
                wrapper = DbAssert.getConnection();
                Statement statement = wrapper.getStatement();
                resultSet = statement.executeQuery(sql);
                if (resultSet.next()) {
                    Assert.fail((String)("Query <" + sql + "> result is not empty, but expected to be empty"));
                }
            }
            catch (SQLException sQLException) {
                throw new AssertionError((Object)"Fail on resultSet.next()");
            }
        }
        catch (Throwable throwable) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL ResultSet");
                }
            }
            if (wrapper != null) {
                try {
                    wrapper.close();
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL statement");
                }
            }
            throw throwable;
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                Assert.fail((String)"Failed to close SQL ResultSet");
            }
        }
        if (wrapper != null) {
            try {
                wrapper.close();
            }
            catch (SQLException sQLException) {
                Assert.fail((String)"Failed to close SQL statement");
            }
        }
    }

    public static void assertLastRow(String table, String id, String field, String expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + " = (SELECT MAX(" + id + ") FROM " + table + ")");
        Assert.assertEquals((Object)expected, (Object)result.get(field));
    }

    public static void assertLastRow(String table, String id, String field, int expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + " = (SELECT MAX(" + id + ") FROM " + table + ")");
        Assert.assertEquals((long)expected, (long)((Number)result.get(field)).intValue());
    }

    public static void assertLastRow(String table, String id, String field, Date expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + " = (SELECT MAX(" + id + ") FROM " + table + ")");
        Assert.assertEquals((Object)expected, (Object)result.get(field));
    }

    public static void assertLastRow(String table, String id, String field, boolean expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + " = (SELECT MAX(" + id + ") FROM " + table + ")");
        Assert.assertEquals((Object)expected, (Object)result.get(field));
    }

    public static int getLastIdNum(String table, String id) {
        return ((Number)DbAssert.getLastId(table, id)).intValue();
    }

    public static String getLastIdStr(String table, String id) {
        return DbAssert.getLastId(table, id).toString();
    }

    private static Object getLastId(String table, String id) {
        String sql;
        ResultSet resultSet;
        ConnectionWrapper wrapper;
        block16: {
            Object object;
            block17: {
                wrapper = null;
                resultSet = null;
                sql = "SELECT MAX(" + id + ") FROM " + table;
                wrapper = DbAssert.getConnection();
                Statement statement = wrapper.getStatement();
                resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) break block16;
                object = resultSet.getObject(1);
                if (resultSet == null) break block17;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL ResultSet");
                }
            }
            if (wrapper != null) {
                try {
                    wrapper.close();
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL statement");
                }
            }
            return object;
        }
        try {
            try {
                throw new AssertionError((Object)"GetLastId returned no data");
            }
            catch (SQLException e) {
                throw new AssertionError("Fail on execute: " + sql, e);
            }
        }
        catch (Throwable throwable) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL ResultSet");
                }
            }
            if (wrapper != null) {
                try {
                    wrapper.close();
                }
                catch (SQLException sQLException) {
                    Assert.fail((String)"Failed to close SQL statement");
                }
            }
            throw throwable;
        }
    }

    public static void assertRow(String table, String id, String idValue, String field, String expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + "='" + idValue + "'");
        Assert.assertEquals((Object)expected, (Object)result.get(field));
    }

    public static void assertRow(String table, String id, String idValue, String field, int expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + "='" + idValue + "'");
        Assert.assertEquals((long)expected, (long)((Number)result.get(field)).intValue());
    }

    public static void assertRow(String table, String id, String idValue, String field, boolean expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + "='" + idValue + "'");
        Assert.assertEquals((Object)expected, (Object)result.get(field));
    }

    public static void assertRow(String table, String id, int idValue, String field, String expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + "=" + idValue);
        Assert.assertEquals((Object)expected, (Object)result.get(field));
    }

    public static void assertRow(String table, String id, int idValue, String field, int expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + "=" + idValue);
        Assert.assertEquals((long)expected, (long)((Number)result.get(field)).intValue());
    }

    public static void assertRow(String table, String id, int idValue, String field, boolean expected) {
        Map<String, Object> result = DbAssert.querySingle("SELECT " + field + " FROM " + table + " WHERE " + id + "=" + idValue);
        Assert.assertEquals((Object)expected, (Object)result.get(field));
    }
}

