/*
 * Decompiled with CFR 0.152.
 */
package com.brokenevent.nanotests;

import java.util.Date;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Asserts {
    protected Asserts() {
    }

    public static void assertEquals(Date expected, Date actual) {
        Assert.assertEquals((long)Math.round((float)expected.getTime() / 1000.0f), (long)Math.round((float)actual.getTime() / 1000.0f));
    }

    public static void assertEquals(String message, Date expected, Date actual) {
        Assert.assertEquals((String)message, (long)Math.round((float)expected.getTime() / 1000.0f), (long)Math.round((float)actual.getTime() / 1000.0f));
    }

    public static void assertNotEquals(Object expected, Object actual) {
        if (!expected.equals(actual)) {
            throw new AssertionError((Object)("Actual value is the same as expected: " + expected));
        }
    }

    public static void assertNotEquals(String message, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertNotEquals(String expected, String actual) {
        if (!expected.equals(actual)) {
            throw new AssertionError((Object)("Actual value is the same as expected: " + expected));
        }
    }

    public static void assertNotEquals(String message, String expected, String actual) {
        if (!expected.equals(actual)) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertNotEquals(int expected, int actual) {
        if (expected != actual) {
            throw new AssertionError((Object)("Actual value is the same as expected: " + expected));
        }
    }

    public static void assertNotEquals(String message, int expected, int actual) {
        if (expected != actual) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertNotEquals(byte expected, byte actual) {
        if (expected != actual) {
            throw new AssertionError((Object)("Actual value is the same as expected: " + expected));
        }
    }

    public static void assertNotEquals(String message, byte expected, byte actual) {
        if (expected != actual) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertNotEquals(long expected, long actual) {
        if (expected != actual) {
            throw new AssertionError((Object)("Actual value is the same as expected: " + expected));
        }
    }

    public static void assertNotEquals(String message, long expected, long actual) {
        if (expected != actual) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertNotEquals(float expected, float actual) {
        if (Math.abs(expected - actual) < 1.0E-4f) {
            throw new AssertionError((Object)("Actual value is the same as expected: " + expected));
        }
    }

    public static void assertNotEquals(String message, float expected, float actual) {
        if (Math.abs(expected - actual) < 1.0E-4f) {
            throw new AssertionError((Object)message);
        }
    }

    public static <T> void assertInSet(T[] superset, T[] subset) {
        int i = 0;
        while (i < subset.length) {
            boolean found = false;
            int j = 0;
            while (j < superset.length) {
                if (subset[i].equals(superset[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                throw new AssertionError((Object)("Element " + subset[i] + " is not found in superset."));
            }
            ++i;
        }
    }

    public static <T> void assertInSet(String message, T[] superset, T[] subset) {
        int i = 0;
        while (i < subset.length) {
            boolean found = false;
            int j = 0;
            while (j < superset.length) {
                if (subset[i].equals(superset[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                throw new AssertionError((Object)message);
            }
            ++i;
        }
    }
}

